<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Ad View</title>
<style>
    body, html {
        margin: 0;
        padding: 0;
        height: 100%;
        overflow: hidden;
    }
    #banner-container {
        height: 100%;
        overflow: hidden;
        position: relative;
    }
    #banner-container img {
        width: 100%;
        height: 100%;
        object-fit: cover;
        position: absolute;
        opacity: 0;
        transition: opacity 1s ease-in-out;
    }
    #banner-container img.active {
        opacity: 1;
    }
</style>
</head>
<body>
<div id="banner-container">
<?php
$diretorio = '../banners/';
if (is_dir($diretorio)) {
    $banners = glob($diretorio . '*.{jpg,jpeg,png,gif}', GLOB_BRACE);
    if ($banners !== false && count($banners) > 0) {
        foreach ($banners as $banner) {
            echo "<img src='$banner' class='banner' alt='Banner'>";
        }
    } else {
        echo "Nenhum banner encontrado.";
    }
} else {
    echo "O diretório de banners não existe.";
}
?>
</div>
<script>
    const banners = document.querySelectorAll('#banner-container img');

    let index = 0;

    function showBanner() {
        banners.forEach((banner, i) => {
            banner.classList.remove('active');
            if (i === index) {
                banner.classList.add('active');
            }
        });
        index = (index + 1) % banners.length;
        setTimeout(showBanner, 5000); // Change image every 5 seconds
    }

    showBanner();
</script>
</body>
</html>
